#include "StdV3D.h"
#include "Basics/Vector.h"
#include "IsoSurface.h"


#include <limits>


namespace V3D {



bool IsoSurface::ComputeBounds( Vector3D& vcBoundMin, Vector3D& vcBoundMax ) const
{
	static const LengthType k_min = std::numeric_limits<LengthType>::min();
	static const LengthType k_max = std::numeric_limits<LengthType>::max();
	vcBoundMin.Set(k_min, k_min, k_min);
	vcBoundMax.Set(k_max, k_max, k_max);
	return false;
}



// Comportement par defaut : tout est interessant dans le plan
// A redefinir dans les classes derivees pour recuperer uniquement les parties considerees interessantes

bool IsoSurface::FindInterestingPartsOfPlane( AllScansArray& aScansPlane,
											const Vector3D& /* vcStart */, const Vector3D& /* vcSteps */,
											int32 nStepsX, int32 nStepsY) const
{
	ScanLineRange rangeX( 0, nStepsX-1);
	ScanLineRange rangeY( 0, nStepsY-1);
	aScansPlane.AddRectangle( rangeX, rangeY);
	return true;
}


void IsoSurface::ComputeSurfaceNormals( Vect3fArray& avNorms, const Vect3DArray& aPos) const
{
	Vect3DArray::size_type nSize = aPos.size();
	if( avNorms.size() != nSize )
		avNorms.resize( nSize );

	ComputeSurfaceNormalsSubArray( avNorms, aPos, 0, nSize);
}



} // namespace

